<?php
class Denuncia {
  public static function create(PDO $pdo, $data){ $st=$pdo->prepare("INSERT INTO denuncias(codigo,titulo,descricao,categoria,localizacao,anonima,denunciante_usuario_id,denunciante_hash,prioridade) VALUES (:codigo,:titulo,:descricao,:categoria,:localizacao,:anonima,:denunciante_usuario_id,:denunciante_hash,:prioridade)"); $st->execute($data); return $pdo->lastInsertId(); }
  public static function findById(PDO $pdo, $id){ $st=$pdo->prepare('SELECT d.*, u.nome as responsavel FROM denuncias d LEFT JOIN usuarios u ON u.id=d.atribuido_a WHERE d.id=:id'); $st->execute([':id'=>$id]); return $st->fetch(); }
  public static function byRoleList(PDO $pdo, $user){ if($user['perfil']==='colaborador'){ $st=$pdo->prepare("SELECT id,codigo,titulo,status,prioridade,criado_em FROM denuncias WHERE denunciante_usuario_id=:id OR anonima=1 ORDER BY criado_em DESC"); $st->execute([':id'=>$user['id']]); return $st->fetchAll(); } return $pdo->query('SELECT id,codigo,titulo,status,prioridade,criado_em FROM denuncias ORDER BY criado_em DESC')->fetchAll(); }
  public static function updateStatus(PDO $pdo,$id,$status,$atribuido=null,$prazo=null){ $st=$pdo->prepare('UPDATE denuncias SET status=:s, atribuido_a=:a, prazo=:p WHERE id=:id'); $st->execute([':s'=>$status,':a'=>$atribuido,':p'=>$prazo,':id'=>$id]); }
  public static function findByCodigo(PDO $pdo,$codigo){ $st=$pdo->prepare('SELECT id,codigo,titulo,status,prioridade,categoria,localizacao,criado_em,atualizado_em FROM denuncias WHERE codigo=:c'); $st->execute([':c'=>$codigo]); $d=$st->fetch(); if(!$d) return null; $c=$pdo->prepare('SELECT texto, criado_em FROM comentarios WHERE denuncia_id=:id AND visivel_ao_denunciante=1 ORDER BY criado_em'); $c->execute([':id'=>$d['id']]); $d['comentarios']=$c->fetchAll(); return $d; }
}
