<?php $usuario = $GLOBALS['_usuario'] ?? null; $isEdit = !empty($usuario); ?>
<h1 class="h4 mb-3"><?= $isEdit ? 'Editar usuário' : 'Novo usuário' ?></h1>
<form method="post" action="<?= $isEdit ? '/usuarios/'.$usuario['id'] : '/usuarios' ?>">
  <input type="hidden" name="csrf" value="<?=csrf_token()?>">
  <div class="row g-3">
    <div class="col-md-6"><label class="form-label">Nome</label><input class="form-control" name="nome" value="<?=safe_str($usuario['nome'] ?? '')?>" required maxlength="120"></div>
    <div class="col-md-6"><label class="form-label">E-mail</label><input type="email" class="form-control" name="email" value="<?=safe_str($usuario['email'] ?? '')?>" required maxlength="160"></div>
    <div class="col-md-4"><label class="form-label">CPF</label><input class="form-control" name="cpf" value="<?=safe_str($usuario['cpf'] ?? '')?>" required maxlength="11" pattern="[0-9]{11}" placeholder="Somente números"></div>
    <div class="col-md-4"><label class="form-label">Telefone (opcional)</label><input class="form-control" name="telefone" value="<?=safe_str($usuario['telefone'] ?? '')?>" maxlength="20"></div>
    <div class="col-md-4"><label class="form-label">Perfil</label><select class="form-select" name="perfil"><?php foreach(['colaborador','gerente','administrador'] as $p): ?><option value="<?=$p?>" <?= isset($usuario['perfil']) && $usuario['perfil']===$p ? 'selected' : '' ?>><?=$p?></option><?php endforeach; ?></select></div>
    <div class="col-md-6"><label class="form-label">Senha <?= $isEdit ? '<small class="text-muted">(preencha para redefinir)</small>' : '' ?></label><input type="password" class="form-control" name="senha" <?= $isEdit ? '' : 'required' ?> minlength="6"></div>
    <?php if($isEdit): ?><div class="col-md-6 form-check mt-4"><input class="form-check-input" type="checkbox" id="ativo" name="ativo" <?= !empty($usuario['ativo'])?'checked':'' ?>><label for="ativo" class="form-check-label">Ativo</label></div><?php endif; ?>
  </div>
  <div class="mt-3"><button class="btn btn-primary">Salvar</button><a class="btn btn-outline-secondary" href="/usuarios">Cancelar</a></div>
</form>
