<?php
require_once __DIR__.'/../lib/rbac.php';
require_once __DIR__.'/../lib/csrf.php';
require_once __DIR__.'/../lib/utils.php';

class UsuariosController {
  public static function index(PDO $pdo){
    require_roles('administrador');
    $rows = $pdo->query("SELECT id, nome, email, cpf, telefone, perfil, ativo, criado_em FROM usuarios ORDER BY nome")->fetchAll();
    $GLOBALS['_usuarios_rows']=$rows;
    $_view = 'usuarios_listar_inner.php';
    require __DIR__.'/../views/layout.php';
  }
  public static function novo(){
    require_roles('administrador');
    $GLOBALS['_usuario']=null;
    $_view = 'usuarios_form_inner.php';
    require __DIR__.'/../views/layout.php';
  }
  public static function criar(PDO $pdo){
    require_roles('administrador'); csrf_check();
    $nome = trim($_POST['nome'] ?? '');
    $email = trim($_POST['email'] ?? '');
    $cpf = preg_replace('/\D/','', $_POST['cpf'] ?? '');
    $telefone = trim($_POST['telefone'] ?? '');
    $perfil = $_POST['perfil'] ?? 'colaborador';
    $senha = $_POST['senha'] ?? '';

    if (!$nome || !$email || !$cpf || !$senha) { $_SESSION['flash'] = 'Preencha Nome, E-mail, CPF e Senha.'; header('Location: /usuarios/novo'); return; }
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) { $_SESSION['flash'] = 'E-mail inválido.'; header('Location: /usuarios/novo'); return; }
    if (!validar_cpf($cpf)) { $_SESSION['flash'] = 'CPF inválido.'; header('Location: /usuarios/novo'); return; }

    $st = $pdo->prepare("INSERT INTO usuarios (nome,email,cpf,telefone,senha_hash,perfil,ativo) VALUES (:n,:e,:c,:t,:p,:r,1)");
    try {
      $st->execute([':n'=>$nome, ':e'=>$email, ':c'=>$cpf, ':t'=>($telefone?:null), ':p'=>password_hash($senha, PASSWORD_BCRYPT), ':r'=>$perfil]);
      $_SESSION['flash_success'] = 'Usuário criado com sucesso.';
      header('Location: /usuarios');
    } catch (PDOException $ex) {
      $_SESSION['flash'] = 'Erro ao criar: ' . ($ex->errorInfo[1] == 1062 ? 'CPF ou e-mail já cadastrado.' : $ex->getMessage());
      header('Location: /usuarios/novo');
    }
  }
  public static function editar(PDO $pdo, $id){
    require_roles('administrador');
    $st = $pdo->prepare('SELECT * FROM usuarios WHERE id = :id');
    $st->execute([':id'=>$id]);
    $u = $st->fetch();
    if (!$u) { http_response_code(404); echo 'Usuário não encontrado'; return; }
    $GLOBALS['_usuario']=$u;
    $_view = 'usuarios_form_inner.php';
    require __DIR__.'/../views/layout.php';
  }
  public static function atualizar(PDO $pdo, $id){
    require_roles('administrador'); csrf_check();
    $nome = trim($_POST['nome'] ?? '');
    $email = trim($_POST['email'] ?? '');
    $cpf = preg_replace('/\D/','', $_POST['cpf'] ?? '');
    $telefone = trim($_POST['telefone'] ?? '');
    $perfil = $_POST['perfil'] ?? 'colaborador';
    $ativo = isset($_POST['ativo']) ? 1 : 0;
    $senha = $_POST['senha'] ?? '';

    if (!$nome || !$email || !$cpf) { $_SESSION['flash'] = 'Preencha Nome, E-mail e CPF.'; header('Location: /usuarios/'.$id+'/editar'); return; }
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) { $_SESSION['flash'] = 'E-mail inválido.'; header('Location: /usuarios/'.$id+'/editar'); return; }
    if (!validar_cpf($cpf)) { $_SESSION['flash'] = 'CPF inválido.'; header('Location: /usuarios/'.$id+'/editar'); return; }

    if ($senha) {
      $sql = 'UPDATE usuarios SET nome=:n,email=:e,cpf=:c,telefone=:t,perfil=:r,ativo=:a,senha_hash=:p WHERE id=:id';
    } else {
      $sql = 'UPDATE usuarios SET nome=:n,email=:e,cpf=:c,telefone=:t,perfil=:r,ativo=:a WHERE id=:id';
    }
    $st = $pdo->prepare($sql);
    $params = [':n'=>$nome,':e'=>$email,':c'=>$cpf,':t'=>($telefone?:null),':r'=>$perfil,':a'=>$ativo,':id'=>$id];
    if ($senha) { $params[':p'] = password_hash($senha, PASSWORD_BCRYPT); }

    try {
      $st->execute($params);
      $_SESSION['flash_success'] = 'Usuário atualizado.';
      header('Location: /usuarios');
    } catch (PDOException $ex) {
      $_SESSION['flash'] = 'Erro ao atualizar: ' . ($ex->errorInfo[1] == 1062 ? 'CPF ou e-mail já cadastrado.' : $ex->getMessage());
      header('Location: /usuarios/'.$id.'/editar');
    }
  }
}
