<?php
require_once __DIR__.'/../lib/auth.php';
require_once __DIR__.'/../lib/rbac.php';
require_once __DIR__.'/../lib/csrf.php';
require_once __DIR__.'/../lib/utils.php';
require_once __DIR__.'/../lib/email.php';
require_once __DIR__.'/../controllers/AuthController.php';
require_once __DIR__.'/../controllers/DenunciasController.php';
require_once __DIR__.'/../controllers/UsuariosController.php';
require_once __DIR__.'/../controllers/CategoriasController.php';
// Removido require direto do model; os controllers já fazem require_once do model quando precisam.

$uri = trim(parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH), '/');
$method = $_SERVER['REQUEST_METHOD'];
csrf_check();

// Públicas
if ($uri==='publico/denuncia' && $method==='GET') { DenunciasController::publicaForm($pdo); exit; }
if ($uri==='publico/denuncia' && $method==='POST') { DenunciasController::publicaCriar($pdo); exit; }
if ($uri==='publico/consulta' && $method==='GET') { DenunciasController::consultaForm(); exit; }
if ($uri==='publico/consulta' && $method==='POST') { DenunciasController::consultaBuscar($pdo); exit; }

// Denúncias (interno)
if (preg_match('#^denuncia/(\d+)$#',$uri,$m) && $method==='GET') { DenunciasController::ver($pdo,$m[1]); exit; }
if (preg_match('#^denuncia/(\d+)/comentario$#',$uri,$m) && $method==='POST') { DenunciasController::comentar($pdo,$m[1]); exit; }
if (preg_match('#^denuncia/(\d+)/status$#',$uri,$m) && $method==='POST') { DenunciasController::atualizarStatus($pdo,$m[1]); exit; }

// Usuários
if (preg_match('#^usuarios/(\d+)/editar$#',$uri,$m) && $method==='GET') { UsuariosController::editar($pdo,$m[1]); exit; }
if (preg_match('#^usuarios/(\d+)$#',$uri,$m) && $method==='POST') { UsuariosController::atualizar($pdo,$m[1]); exit; }

// Categorias (admin)
if ($uri==='categorias' && $method==='GET') { CategoriasController::index($pdo); exit; }
if ($uri==='categorias/novo' && $method==='GET') { CategoriasController::novo(); exit; }
if ($uri==='categorias' && $method==='POST') { CategoriasController::criar($pdo); exit; }
if (preg_match('#^categorias/(\d+)/editar$#',$uri,$m) && $method==='GET') { CategoriasController::editar($pdo,$m[1]); exit; }
if (preg_match('#^categorias/(\d+)$#',$uri,$m) && $method==='POST') { CategoriasController::atualizar($pdo,$m[1]); exit; }
if (preg_match('#^categorias/(\d+)/excluir$#',$uri,$m) && $method==='POST') { CategoriasController::excluir($pdo,$m[1]); exit; }

switch (true) {
  case $uri === '' && $method==='GET': auth_check(); $_view='home_inner.php'; require __DIR__.'/../views/layout.php'; break;
  case $uri==='login' && $method==='GET': AuthController::showLogin(); break;
  case $uri==='login' && $method==='POST': AuthController::login($pdo); break;
  case $uri==='logout': AuthController::logout(); break;

  case $uri==='denuncias' && $method==='GET': DenunciasController::listar($pdo); break;
  case $uri==='denuncia/nova' && $method==='GET': DenunciasController::novaForm($pdo); break;
  case $uri==='denuncia' && $method==='POST': DenunciasController::criar($pdo); break;

  case $uri==='usuarios' && $method==='GET': UsuariosController::index($pdo); break;
  case $uri==='usuarios/novo' && $method==='GET': UsuariosController::novo(); break;
  case $uri==='usuarios' && $method==='POST': UsuariosController::criar($pdo); break;

  default: http_response_code(404); echo '404';
}
